/*
 * SX.cpp
 *
 *  Created on: 02.01.2012
 *  Changed on: 31.01.2012
 *  Changed on: 09.10.2013 by Uli Beyenbach
 *  Version:    1.3
 *  Copyright:  Michael Blank
 *
 *  interface hardware needed ! see www.oscale.net/selectrix


 Read Selectrix Signal - SX Clock must be connected to Pin2=INT0 and
 SX Data must be connected to Pin4, and SX Data OUT (back to central
 station) at Pin12. For triggering a scope, a signal
 can be generated at Arduino-Pin13 at a defined base address.

 (Uses digitalRead() function for maximum portability - is not optimized 
 for speed of ISR routine!)
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

 Selectrix(TM) is a trademark of Maerklin GmbH, Goeppingen, Germany

 */


#include "SX1.h"


SX::SX() {
    _scopeFlag = 0;
}

void SX::init() {
     // initialize function
     // initialize pins and variables
     // and start looking for a SYNC signal

	pinMode(SX_CLK, INPUT);      // SX-clock is an input
	pinMode(SX_DATA,INPUT);      // SX-data is also an input
	digitalWrite(SX_CLK, HIGH);  // = enable pullup resistor
	digitalWrite(SX_DATA, HIGH); // = enable pullup resistor

	for (int i=0; i<112;i++) {
          // reset sx variable to zero
		_sx[i]=0;
	}
     _toggle=0;
	_adrCount =0;

	// start always with search for SYNC
	_state = SYNC;
	_zeroCount = 0;

     _sx_write_busy=0;
     _sx_writing = 0;
     _zx_new = 2;	//idle state
}

void SX::init(uint8_t tba) {
     // special init which enable a scope trigger
     // at a certain base-address tba (must be 0..15)
     _scopeFlag=1;
     pinMode(SCOPE,OUTPUT);
     _triggerBaseAdr = tba;
     init();
}

void SX::switchAdr() {
     // a SYNC signal was received, now look for a valid
     // base address
	switch(_adrCount) {
	case 0: // this is the GLEISSPANNUNG bit
	        _zx=_bit;
                if (_zx_new != 2) {
                DDRB |= (1<<PORTB4);	//Pin 12 (=SX_OUT) OUTPUT
                sxWrite(_zx_new);
                }
                break;
	case 1: if (_zx_new != 2) {
                _zx_new = 2;
	        DDRB &= ~(1<<PORTB4);
                }
	case 4:
		break; // ignore
	case 2:  // B3
		bitWrite(_baseAdr,3,_bit);
		break;
	case 3:  // B2
		bitWrite(_baseAdr,2,_bit);
		break;
	case 5:  // B1
		bitWrite(_baseAdr,1,_bit);
		break;
	case 6:  // B0
		bitWrite(_baseAdr,0,_bit);
		break;
	case 7: // last "1"
          // _baseAdr is complete !

          // check if scope triggering was enabled
          // if yes, check if _triggerBaseAdr is reached
          if (_scopeFlag) {
		    if (_baseAdr == _triggerBaseAdr)  {
			   digitalWrite(SCOPE,HIGH);
		    } else {
			   digitalWrite(SCOPE,LOW);
		    }
          }
 
		// advance to next state - next we are looking
          // for the 7 data bytes (i.e. 7 SX Channels)
		_state = DATA;  
		_dataFrameCount = 0;
		_dataBitCount = 0;
		_data=0;
		break;
	}
}

void SX::switchData() {
	// continue reading _data
	// a total of 7 DATA blocks will be received
     // for a certain base-address

	switch(_dataBitCount) {
	case 2:  // "Trenn_bits"
        case 5:
          if(_channel < _nullMax) PORTB |= (1<<PORTB4);	//HIGH schreiben
	case 8:
          if (_sx_write_busy) PORTB |= (1<<PORTB4);  //digitalWrite(SX_OUT,HIGH);
		_dataBitCount++;
		break; // ignore
	case 0:  // D0
		// calc sx channel from baseAdr and dataFrameCount
		_channel = (15-_baseAdr) + ((6-_dataFrameCount)<<4);
   
          // initiate write if requested
          if ((_sx_write_busy) && (_channel == _sx_set_channel)) {
              DDRB |= (1<<PORTB4);	//Pin 12 (=SX_OUT) OUTPUT
              sxWrite(bitRead(_sx_set_data,0));
              _sx_writing=1;
          } else  {
              DDRB &= ~(1<<PORTB4);  //pinMode(SX_OUT,INPUT);  // high impedance
              _sx_writing=0;
          }
          if(_channel < _nullMax){
              DDRB |= (1<<PORT4);	//Pin 12 OUTPUT
              PORTB &= ~(1<<PORTB4);	//LOW schreiben
	  }  

		_data=0;
		bitWrite(_data,0,_bit);
		_dataBitCount++;
		break;
	case 1:  // D1
          if(_channel < _nullMax){
                PORTB &= ~(1<<PORTB4);
          }
          if (_sx_writing) sxWrite(bitRead(_sx_set_data,1));
               //digitalWrite(SX_OUT,bitRead(_sx_set_data,1));
		bitWrite(_data,1,_bit);
		_dataBitCount++;
		break;
	case 3:  // D2
          if(_channel < _nullMax){
                PORTB &= ~(1<<PORTB4);
          }

          if (_sx_writing) sxWrite(bitRead(_sx_set_data,2));
                //digitalWrite(SX_OUT,bitRead(_sx_set_data,2));
		bitWrite(_data,2,_bit);
		_dataBitCount++;
		break;
	case 4:  // D3
          if(_channel < _nullMax){
                PORTB &= ~(1<<PORTB4);
          }

          if (_sx_writing) sxWrite(bitRead(_sx_set_data,3));
                //digitalWrite(SX_OUT,bitRead(_sx_set_data,3));
		bitWrite(_data,3,_bit);
		_dataBitCount++;
		break;
	case 6:  // D4
          if(_channel < _nullMax){
                PORTB &= ~(1<<PORTB4);
          }

         if (_sx_writing) sxWrite(bitRead(_sx_set_data,4));
                 //digitalWrite(SX_OUT,bitRead(_sx_set_data,4));
		bitWrite(_data,4,_bit);
		_dataBitCount++;
		break;
	case 7:  // D5
          if(_channel < _nullMax){
                _nullCount--;
                DDRB &= ~(1<<PORTB4);
                if( !_nullCount){
                   _nullMax=0;
                }
          }

         if (_sx_writing) sxWrite(bitRead(_sx_set_data,5));
                //digitalWrite(SX_OUT,bitRead(_sx_set_data,5));
		bitWrite(_data,5,_bit);
		_dataBitCount++;
		break;
	case 9:  // D6
         if (_sx_writing) sxWrite(bitRead(_sx_set_data,6));
                //digitalWrite(SX_OUT,bitRead(_sx_set_data,6));
		bitWrite(_data,6,_bit);
		_dataBitCount++;
		break;
	case 10: // D7
         if (_sx_writing) sxWrite(bitRead(_sx_set_data,7));
                //digitalWrite(SX_OUT,bitRead(_sx_set_data,7));
		bitWrite(_data,7,_bit);
		_dataBitCount++;
		break;
	case 11:  // == MAX_DATABITCOUNT
		// _bit value should always equal HIGH, not tested here.

		if (_sx_writing){
                  DDRB &= ~(1<<PORTB4);
                  //pinMode(SX_OUT,INPUT);
                  _sx_writing = 0;  // reset writing mode.
	          _sx_write_busy=0;	
                }
		// copy _data byte to SX _channel
		_sx[_channel] = _data;

          // increment dataFrameCount to move on the next DATA byte
          // check, if we already reached the last DATA block - in this
          // case move on to the next SX-Datenpaket, i.e. look for SYNC
		_dataFrameCount ++;
		if (_dataFrameCount == MAX_DATACOUNT) {
			// and move on to SYNC _state
			_dataFrameCount=0;
			_state =SYNC;
			_zeroCount = 0;
			_dataBitCount=0;
		} else {
			_dataBitCount = 0;  // reset _bit counter
			_data = 0;
			// continue with reading next _data uint8_t
		}
	}  //end switch/case _dataBitCount
}
void SX::sxWrite(uint8_t wert) {
		if(wert) PORTB |= (1<<PORTB4);
                 else PORTB &= ~(1<<PORTB4);
}

uint8_t SX::get(uint8_t channel) {
     // returns the value of a selectrix channel
	if (channel < MAX_CHANNEL_NUMBER)
	   return _sx[channel];
	else
	   return 0;
}

uint8_t SX::set(uint8_t ch, uint8_t d) {
     if (_sx_write_busy) return 1;  // dont accept new data
     _sx_set_channel = ch;
     _sx_set_data = d;

     // then set busy flag
     _sx_write_busy=1;
     return 0; //sucess
}

void SX::setg(uint8_t d) {
     // sets the new value of the GLEISSPANNUNG bit
     if (d == 0 || d==1) {
     _zx_new = d;
     }
}

uint8_t SX::getg() {
     // returns the value of the GLEISSPANNUNG bit
     return _zx;
}

void SX::set0(uint8_t wert){
    // setzt alle Fahrstufen von 1 bis wert auf Null
    _nullMax = wert+1;
    if(_nullMax > MAX_CHANNEL_NUMBER){_nullMax=MAX_CHANNEL_NUMBER;}
    _nullCount=_nullMax-1;
}

void SX::isr() {

	// interrupt service routine (AVR INT0)
	// driven by RISING clock signal T0 (SX pin 1)

     // 3 different states are distinguished
     //     1. SNYC = looking for a SYNC signal
     //     2. ADDR = (after SYNC received) look for base address (0..15)
     //     3. DATA = (after ADDR decoded) decode the 7 data-bytes

	_bit = digitalRead(SX_DATA); 
	switch(_state) {
	case SYNC:

		if (_bit == LOW)  {
			_zeroCount++;
		} else {
			if (_zeroCount == 3)  {        // sync bits 0 0 0 1 found
				_state = ADDR;         // advance to next state
				_baseAdr = 0;   //init
				_adrCount = 0;  //init
			} else {  // no valid sync, try again ...
				_zeroCount = 0;       // reset _zeroCounter
			} // endif _zeroCount
		}  // endif _bit==LOW
		break;
	case ADDR:
		switchAdr();
		_adrCount++;
		break;
	case DATA:
		switchData();
	}
}


