/*
 * SX.h
 *
 *  Created on: 02.01.2012
 *  Changed on: 31.01.2012
 *  Changed on: 09.10.2013 by Uli Beyenbach
 *  Version:    1.3
 *  Copyright:  Michael Blank

 *  interface hardware needed ! see www.oscale.net/selectrix

 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


 Selectrix(TM) is a trademark of Maerklin GmbH, Goeppingen, Germany

 */

#ifndef SX_H_
#define SX_H_

#include <inttypes.h>
#include <Arduino.h>

// define arduino pins 
#define SX_CLK   2     // must be INT0 !!
#define SX_DATA  4
#define SCOPE  13
#define SX_OUT 12  // pin for sending data back to central station


// defines for state machine
#define SYNC  0
#define ADDR  1
#define DATA  2

#define MAX_DATACOUNT    7    // 7 dataframes in 1 SYNC Channel
#define MAX_DATABITCOUNT 12   // 12 bits in 1 frame

#define MAX_CHANNEL_NUMBER 112   // SX channels


class SX {
public:
	SX();
	void init(void);
        void init(uint8_t);
	uint8_t get(uint8_t);
	void isr(void);
        uint8_t set(uint8_t, uint8_t);
        void setg(uint8_t);
        uint8_t getg();
        void set0(uint8_t);

private:
	void switchAdr(void);
	void switchData(void);
        void sxWrite(uint8_t);
        
        uint8_t _zx;	//GLEISSPANNUNG bit
        uint8_t _zx_new;//new GLEISSPANNUNG bit
	uint8_t _toggle;
	uint8_t _zeroCount;
	uint8_t _adrCount;
	uint8_t _state;
	uint8_t _dataBitCount;    // bit counting
	uint8_t _dataFrameCount;  // frame counting

	uint8_t _data;    // 1 data uint8_t
	uint8_t _baseAdr;   // base address
     uint8_t _triggerBaseAdr;
     uint8_t _scopeFlag;   // generate scope trigger signal if != 0

	uint8_t _bit;
	uint8_t _sx[MAX_CHANNEL_NUMBER];   // to store the SX data

	uint8_t _channel;   // channel from 0 to 15, B3..B0 in sync data
	// 0  0  0  1  X   1  B3  B2  1  B1  B0  1 == sync frame of 12 bits
	uint8_t _sx_set_channel;   // stores channel number to write to
     uint8_t _sx_set_data;      // data to write
     uint8_t _sx_write_busy;    // waiting to send data, cannot accept new data
     uint8_t _sx_writing;  // currently writing a byte

	uint8_t _nullMax;	//max Kanal fr Nullstellen
	uint8_t _nullCount;	//Zhler


	/* SX Timing
	 1   Bit             50 us
	 1   Kanal          600 us (= 12 Bit)
	 1   Grundrahmen    ca. 4,8 ms
	 1   Gesamtrahmen   ca. 78 ms (= 16 Grundrahmen)  */
};

#endif /* SX_H_ */

